<?php

/**
 * 购买活跃度会员,临时用,需消耗
 */

namespace Game\Controller\Proficiency;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\ProficiencyLogic;
use Game\Protobuf\CGBuyProficiencyFlag;
use Game\Protobuf\GCBuyProficiencyFlag;
use Game\Protobuf\PacketId;

class CG_BuyProficiencyFlag extends ControllerBase
{
    use ProficiencyLogic;

    private GCBuyProficiencyFlag $sendMessage;

    public function __construct()
    {
        $this->message = new CGBuyProficiencyFlag();
        $this->sendMessage = new GCBuyProficiencyFlag();
    }

    public function run(): int
    {
        $code = $this->checkOpenTotalProficiencyExpertFlag();
        if ($code != ClientErrorCode::CLIENT_SUCCESS) {
            $this->sendMessage->setCode($code);
            SendMessage::getInstance()->sendClient(PacketId::GC_BuyProficiencyFlag, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        $this->sendProficiencyDataMessage($this->openTotalProficiencyExpertFlag());
        return ErrorDefine::SUCCESS;
    }
}
