<?php

/***
 * 段位信息
 */

namespace Game\Controller;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Game\Constant\ModelTypeDefine;
use Game\Protobuf\CGPaiweiLevelInfo;
use Game\Protobuf\GCPaiweiLevelInfo;
use Game\Model\PaiweiLevelModel;

class PaiweiLevelGet extends ControllerBase
{
    private GCPaiweiLevelInfo $sendMessage;

    public function __construct()
    {
        $this->message = new CGPaiweiLevelInfo();
        $this->sendMessage = new GCPaiweiLevelInfo();
    }

    public function run(): int
    {
        //获取段位信息
        /**
         * @var PaiweiLevelModel $levelModel
         */
        $levelModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PAIWEI_LEVEL);
        $levelModel->searchLevelData();
        $levelModel->addSendMessage();
        $levelModel->sendMessage();
        return ErrorDefine::SUCCESS;
    }
}