<?php

/**
 * 技巧教学关通关检查
 */

namespace Game\Controller\PVE;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateTale;
use Game\Constant\EventTypeDefine;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TaskLogicDefine;
use Game\Constant\TemplateDefine;
use Game\Data\PVE\LevelData;
use Game\Logic\PVE\PveSettlementLogic;
use Game\Model\PVE\PveModel;
use Game\Protobuf\CGPveWatchVideo;
use Game\Protobuf\GCFinishPveResult;
use Game\Protobuf\GCPveWatchVideo;
use Game\Protobuf\PacketId;

class CG_PveWatchVideo extends ControllerBase
{
    use PveSettlementLogic;

    private GCPveWatchVideo $sendMessage;

    public function __construct()
    {
        $this->message = new CGPveWatchVideo();
        $this->sendMessage = new GCPveWatchVideo();
    }

    public function run(): int
    {
        $levelId = $this->message->getLevelId();
        //校验
        $code = $this->checkPveLevel($levelId, 0);
        if ($code != ClientErrorCode::CLIENT_SUCCESS) {
            $this->sendMessage->setCode($code);
            SendMessage::getInstance()->sendClient(PacketId::GC_PveWatchVideo, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        $levelConfig = $this->getTitle(TemplateDefine::TYPE_TALE, $levelId);
        if ($levelConfig[TemplateTale::Type] != TemplateTale::TYPE_TEACHING_SKILL) {
            //主线,支线 不支持此功能,如有需要再添加
            $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
            SendMessage::getInstance()->sendClient(PacketId::GC_PveWatchVideo, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        //检查关卡状态 已通关的 不再检查目标完成
        /**
         * @var PveModel $pveModel
         */
        $pveModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PVE);
        $levelData = $pveModel->getLevelData($levelId);
        if ($levelData->status == LevelData::STATUS_DOING) {
            //检查关卡通关条件
            if ($levelConfig[TemplateTale::VitalTargetType] == TaskLogicDefine::TASK_CONDITION_WATCH_VIDEO &&
                $levelConfig[TemplateTale::SkillTeachId] == $this->message->getVideoId()
            ) {
                $compTarget = array(1, 1, 1);
                //技巧教学关卡
                $this->checkCompleteTeachingSkillLevel($levelData, $levelConfig, $compTarget);
                $param = array(
                    GameConstantDefine::EVENT_KEY_PVE_LEVEL_ID => $levelData->levelId,
                );
                $this->triggerEvent(EventTypeDefine::EVENT_TYPE_TASK_COMPLETE_PVE_LEVEL, $param);
            }
        }
        //发送消息
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        SendMessage::getInstance()->sendClient(PacketId::GC_PveWatchVideo, $this->sendMessage);
        $sendMessage = new GCFinishPveResult();
        $sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        SendMessage::getInstance()->sendClient(PacketId::GC_FinishPveResult, $sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
