<?php

/**
 * pve结算
 */

namespace Game\Controller\PVE;

use Framework\Define\ErrorDefine;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateTale;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Data\PVE\LevelData;
use Game\Logic\AccountLogic;
use Game\Logic\PVE\PveSettlementLogic;
use Game\Model\PVE\PveModel;
use Game\Protobuf\CGFinishPve;
use Game\Protobuf\GCFinishPveResult;
use Game\Protobuf\PacketId;
use Game\Protobuf\PlayerMark;

class CG_FinishPve extends ControllerBase
{
    use PveSettlementLogic;
    use AccountLogic;

    private GCFinishPveResult $sendMessage;

    public function __construct()
    {
        $this->message = new CGFinishPve();
        $this->sendMessage = new GCFinishPveResult();
    }

    public function run(): int
    {
        $levelId = $this->message->getLevelId();
        $myPlayerMark = null;
        foreach ($this->message->getPlayerList() as $playerMark) {
            /**
             * @var PlayerMark $playerMark
             */
            if ($this->playerId == $playerMark->getPlayerId()) {
                $myPlayerMark = $playerMark;
                break;
            }
        }
        if (is_null($myPlayerMark)) {
            LogMark::getInstance()->markDebug(
                "[CG_FinishPve] not found player data",
                array(
                    "player" => $this->message->getPlayerList()
                )
            );
            $this->sendMessage->setCode(ClientErrorCode::PVE_LEVEL_NOT_FOUND_PLAYER);
            SendMessage::getInstance()->sendClient(PacketId::GC_FinishPveResult, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        //整理参数
        $carTplId = $myPlayerMark->getCarId();
        //校验
        $code = $this->checkPveLevel($levelId, $carTplId);
        if ($code != ClientErrorCode::CLIENT_SUCCESS) {
            LogMark::getInstance()->markDebug(
                "[CG_FinishPve] check level error"
            );
            $this->sendMessage->setCode($code);
            SendMessage::getInstance()->sendClient(PacketId::GC_FinishPveResult, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }

        $tplLevel = $this->getTitle(TemplateDefine::TYPE_TALE, $levelId);
        if (in_array($tplLevel[TemplateTale::Type], [TemplateTale::TYPE_MAIN, TemplateTale::TYPE_BRANCH])){
            //游戏关卡主线，支线检查
            $levelData = new LevelData($this->playerId);
            $levelData->levelId = $levelId;
            $this->checkCompleteLevel($levelData, $this->message->getTarget(), $this->message->getMatchOperation(), $myPlayerMark);
        } else {
            //检查关卡状态 已通关的 不再检查目标完成
            /**
             * @var PveModel $pveModel
             */
            $pveModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PVE);
            $levelData = $pveModel->getLevelData($levelId);
            if ($levelData->status == LevelData::STATUS_DOING) {
                $this->checkCompleteLevel($levelData, $this->message->getTarget(), $this->message->getMatchOperation(), $myPlayerMark);
            }
        }
        $this->upRoleStatus(GameConstantDefine::PLAYER_STATUS_ONLINE, $this->playerId);
        //发送消息
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        SendMessage::getInstance()->sendClient(PacketId::GC_FinishPveResult, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
