<?php

/**
 * 进入pve关卡
 */

namespace Game\Controller\PVE;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateTale;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Data\PVE\CareerChapterData;
use Game\Logic\AccountLogic;
use Game\Logic\CarLogic;
use Game\Logic\PVE\PveSettlementLogic;
use Game\Model\PVE\PveModel;
use Game\Operation\EventLog\EventLog_Manager;
use Game\Operation\EventLog\EventLogType;
use Game\Operation\EventLog\StartPVELog;
use Game\Protobuf\CGEnterPve;
use Game\Protobuf\GCEnterPveResult;
use Game\Protobuf\PacketId;

class CG_EnterPve extends ControllerBase
{
    use PveSettlementLogic;
    use CarLogic;
    use AccountLogic;

    private GCEnterPveResult $sendMessage;

    public function __construct()
    {
        $this->message = new CGEnterPve();
        $this->sendMessage = new GCEnterPveResult();
    }

    public function run(): int
    {
        $code = $this->checkPveLevel($this->message->getLevelId(), $this->message->getCarTplId());
        $this->sendMessage->setCode($code);
        if ($code == ClientErrorCode::CLIENT_SUCCESS) {
            $this->recordCarUseNum($this->message->getCarTplId());
            $this->upRoleStatus(GameConstantDefine::PLAYER_STATUS_GAMING, $this->playerId);
            $this->addEventLog();
        }
        SendMessage::getInstance()->sendClient(PacketId::GC_EnterPveResult, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }

    private function addEventLog()
    {
        //记录打点日志
        $levelConfig = $this->getTitle(TemplateDefine::TYPE_TALE, $this->message->getLevelId());
        /**
         * @var PveModel $pveModel
         */
        $pveModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PVE);
        $log = EventLog_Manager::getInstance()->getEventLog(EventLogType::StartPVE);
        if (!is_null($log)) {
            /**
             * @var StartPVELog $log
             */
            $log->chapterId = $levelConfig[TemplateTale::Chapters];
            $log->levelId = $this->message->getLevelId();
            $log->pveType = $levelConfig[TemplateTale::Type];
            //生涯
            if (in_array($levelConfig[TemplateTale::Type], array(TemplateTale::TYPE_MAIN, TemplateTale::TYPE_BRANCH))) {
                $chapterData = $pveModel->getCareerChapterData($levelConfig[TemplateTale::Chapters]);
                $log->chapterStarNum = $pveModel->getAllStarNum($levelConfig[TemplateTale::Chapters]);
                $log->chapterRewardStatus = $chapterData[CareerChapterData::StarReward];
            } else {
                //其他pve模式,都是一次性通关,星数为进度*3
                $chapterData = $pveModel->getChapterData($levelConfig[TemplateTale::Chapters]);
                $log->chapterStarNum = $chapterData->examSchedule * 3;
                $log->chapterRewardStatus = 0;
            }
            $log->carId = $this->message->getCarTplId();
            $log->markLog();
        }
    }
}
