<?php
/**
 * 玩家TO玩家的信息, 通用消息
 * @date 2022/8/10
 * @author JZW
 **/

namespace Game\Controller\Notice;


use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\MVC\ControllerBase;
use Game\Logic\NoticeLogic;
use Game\Protobuf\CGSendOnLineNotice;

class sendTips extends ControllerBase
{
    use NoticeLogic;

    public function __construct()
    {
        $this->message = new CGSendOnLineNotice();
    }

    public function run(): int
    {
        $otherId = $this->message->getPlayerId();
        $tipsId = $this->message->getTipsId();
        $source = $this->message->getSource();
        $data = [
            "Time" => Utils::getServerTimestamp(),
            "TipsId" => $tipsId,
        ];
        $this->sendSourceTipsNotice($otherId, $source, $data);
        return ErrorDefine::SUCCESS;
    }
}