<?php
/**
 * 客户端未处理notice提示, 直接关闭
 * @date 2022/9/15
 * @author JZW
 **/

namespace Game\Controller\Notice;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Data\NoticeData;
use Game\Logic\NoticeLogic;
use Game\Protobuf\CGCloseNotice;

class close extends ControllerBase
{
    use NoticeLogic;

    public function __construct()
    {
        $this->message = new CGCloseNotice();
    }

    public function run(): int
    {
        $otherPlayerId = $this->message->getPlayerId();
        $source = $this->message->getSource();

        if ($source == NoticeData::Source_Friend_Game) {
            $this->delNotice($otherPlayerId, NoticeData::Notice_Index_Invited_Game);
        }
        return ErrorDefine::SUCCESS;
    }
}