<?php

/**
 * Notice.php
 */

namespace Game\Controller;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Config\GameConfig;
use Game\Constant\ClientErrorCode;
use Game\Logic\AccountLogic;
use Game\Protobuf\CGGetNoticeInfo;
use Game\Protobuf\GCGetNoticeInfo;
use Game\Protobuf\PacketId;

class Notice extends ControllerBase
{
    use AccountLogic;

    private GCGetNoticeInfo $sendMessage;

    public function __construct()
    {
        $this->message = new CGGetNoticeInfo();
        $this->sendMessage = new GCGetNoticeInfo();
    }

    public function run(): int
    {
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMessage->setNoticeIP(GameConfig::getInstance()->NOTICE_SERVER_IP());
        $this->sendMessage->setNoticePort(GameConfig::getInstance()->NOTICE_SERVER_PORT());
        SendMessage::getInstance()->sendClient(PacketId::GC_GetNoticeInfo, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
