<?php

/**
 * 拒绝索要战令
 */

namespace Game\Controller\Mail;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Data\MailData;
use Game\Logic\MailLogic;
use Game\Model\MailModel;
use Game\Protobuf\CGRefuseDemandZL;
use Game\Protobuf\GCRefuseDemandZL;
use Game\Protobuf\PacketId;

class RefuseDemandZL extends ControllerBase
{
    use MailLogic;
    private GCRefuseDemandZL $sendMessage;

    public function __construct()
    {
        $this->message = new CGRefuseDemandZL();
        $this->sendMessage = new GCRefuseDemandZL();
    }

    public function run(): int
    {
        $mailID = $this->message->getMailID();
        /**
         * @var MailData $mail
         */
        $mail = $this->getSingleMailInfo($mailID);
        if (is_null($mail)) {
            $this->sendMessage->setCode(ClientErrorCode::MAIL_NOT_EXIT);
            $this->sendMessage->setMailID($mailID);
            SendMessage::getInstance()->sendClient(PacketId::GC_RefuseDemandZL, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        $mailTID = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_ZL_Demand_Mail_ID, TemplateConst::ConstNum);
        if($mail->mailTplId != $mailTID) {
            $this->sendMessage->setCode(ClientErrorCode::SHOP_ZL_MAIL_NOT_DEMAND);
            $this->sendMessage->setMailID($mailID);
            SendMessage::getInstance()->sendClient(PacketId::GC_RefuseDemandZL, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        $mailTplID = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_ZL_Refuse_Demand_Mail_ID, TemplateConst::ConstNum);
        $rep = json_decode($mail->replaceString, true);
        //给对方发拒绝邮件
        $replaceString = $this->replaceMailContent($mailTplID, array(
            GameConstantDefine::MAIL_KEY_PLAYER_NAME => $this->playerId,
            GameConstantDefine::MAIL_KEY_ITEM_ID => $rep[GameConstantDefine::MAIL_KEY_ITEM_ID]
        ));
        $this->createPlayerMail(
            $mailTplID,
            Utils::getServerTimestamp(),
            array(),
            0,
            $mail->fromPlayerId,
            $this->playerId,
            "",
            $replaceString
        );

        $this->singleMailDel($mailID, true);
        $this->sendMailMessage();

        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMessage->setMailID($mailID);
        SendMessage::getInstance()->sendClient(PacketId::GC_RefuseDemandZL, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
