<?php

/**
 * 邮件领取战令
 */

namespace Game\Controller\Mail;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\ConstTemplate\TemplateMail;
use Game\Constant\GameConstantDefine;
use Game\Constant\TemplateDefine;
use Game\Data\MailData;
use Game\Data\WarTokenData;
use Game\Logic\Friend\FriendLogic;
use Game\Logic\MailLogic;
use Game\Protobuf\CGReceiveZL;
use Game\Protobuf\GCReceiveZL;
use Game\Protobuf\PacketId;
use Game\Logic\WarTokenLogic;

class ReceiveZL extends ControllerBase
{
    use MailLogic;
    use WarTokenLogic;
    use FriendLogic;

    private GCReceiveZL $sendMessage;
    public function __construct()
    {
        $this->message = new CGReceiveZL();
        $this->sendMessage = new GCReceiveZL();
    }
    
    public function run(): int
    {
        $mailID = $this->message->getMailID();
        /**
         * @var MailData $mail
         */
        $mail = $this->getSingleMailInfo($mailID);
        if (is_null($mail)) {
            $this->sendMessage->setCode(ClientErrorCode::MAIL_NOT_EXIT);
            $this->sendMessage->setMailID($mailID);
            SendMessage::getInstance()->sendClient(PacketId::GC_ReceiveZL, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }

        $mailTID = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_ZL_To_My_Give_Mail_ID, TemplateConst::ConstNum);
        if($mail->mailTplId != $mailTID) {
            $this->sendMessage->setCode(ClientErrorCode::SHOP_ZL_MAIL_NOT_DEMAND);
            $this->sendMessage->setMailID($mailID);
            SendMessage::getInstance()->sendClient(PacketId::GC_ReceiveZL, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }

        $rep = json_decode($mail->replaceString, true);

        $itemID = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_ZL_Primary_Item_ID,
            TemplateConst::ConstNum);
        if($rep[GameConstantDefine::MAIL_KEY_ITEM_ID] == $itemID) {
            $level = WarTokenData::EXPERT_FLAG_PRIMARY;
            $exchangeMailID = $this->getTerm(TemplateDefine::TYPE_CONST,
                TemplateConst::Const_ZL_Primary_Change,
                TemplateConst::ConstNum);
        } else {
            $level = WarTokenData::EXPERT_FLAG_EXPERT;
            $exchangeMailID = $this->getTerm(TemplateDefine::TYPE_CONST,
                TemplateConst::Const_ZL_Expert_Change,
                TemplateConst::ConstNum);
            $itemID = $this->getTerm(TemplateDefine::TYPE_CONST,
                                     TemplateConst::Const_ZL_Expert_Item_ID,
                                     TemplateConst::ConstNum);
        }

        // 判断是否已经开启 开启则发送兑换邮件
        $code = $this->checkOpenExpertFlag();
        if ($code != ClientErrorCode::CLIENT_SUCCESS) {
            $this->sendMessage->setCode($code);
            //替换邮件内容
            $replaceString = $this->replaceMailContent($exchangeMailID, array(
                GameConstantDefine::MAIL_KEY_OTHER_NAME => $mail->fromPlayerId,
                GameConstantDefine::MAIL_KEY_ITEM_ID => $itemID
            ));
            $this->createPlayerMail(
                $exchangeMailID,
                Utils::getServerTimestamp(),
                array(),
                0,
                $this->playerId,
                $mail->fromPlayerId,
                "",
                $replaceString
            );
            $this->singleMailDel($mailID, true);
            SendMessage::getInstance()->sendClient(PacketId::GC_ReceiveZL, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        //增加亲密度 赠送战令
        $point = $this->getTerm(
            TemplateDefine::TYPE_CONST,
            TemplateConst::Const_Intimacy_Add_Point_Send_ZLGift,
            TemplateConst::ConstNum);
        $this->addFriendIntimacy($mail->fromPlayerId, $point, GameConstantDefine::INTIMACY_SOURCE_ZL_GIFT);

        // 开通对应战令
        $this->openExpertFlag($level);
        // 提升等级
        $this->addZlLevel($level);
        // 返回消息
        $this->singleMailDel($mailID, true);

        $this->sendMailMessage();
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMessage->setMailID($mailID);
        SendMessage::getInstance()->sendClient(PacketId::GC_ReceiveZL, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
