<?php

/**
 * 获取邮件
 */

namespace Game\Controller\Mail;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\MailLogic;
use Game\Protobuf\CGMailSearch;

class CG_MailSearch extends ControllerBase
{
    use MailLogic;

    public function __construct()
    {
        $this->message = new CGMailSearch();
    }

    public function run(): int
    {
        $start = $this->message->getStart();
        $stop = $this->message->getEnd();
        $this->getAllMailByIndex($start, $stop);
        return ErrorDefine::SUCCESS;
    }
}
