<?php

/**
 * 玩家邮件操作
 */

namespace Game\Controller\Mail;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\MailLogic;
use Game\Protobuf\CGMailOption;
use Game\Protobuf\GCMailOptionResult;
use Game\Protobuf\PacketId;

class CG_MailOption extends ControllerBase
{
    use MailLogic;

    private GCMailOptionResult $sendMessage;

    public const OPTION_SINGLE_READ = 1;            //单个邮件设置已读
    public const OPTION_SINGLE_GET_ENCLOSURE = 2;   //单个邮件领取附件
    public const OPTION_SINGLE_DEL = 3;             //单个邮件删除
    public const OPTION_ALL_DELETE_ALREADY_READ = 4;    //一键删除已读邮件
    public const OPTION_ALL_GET_ENCLOSURE = 5;  //一键领取附件

    public function __construct()
    {
        $this->message = new CGMailOption();
        $this->sendMessage = new GCMailOptionResult();
    }

    public function run(): int
    {
        $option = $this->message->getOption();
        $code = null;
        switch ($option)
        {
            case self::OPTION_SINGLE_READ:
                $code = $this->singleMailRead($this->message->getMailId());
                break;
            case self::OPTION_SINGLE_GET_ENCLOSURE:
                $code = $this->singleMailGet($this->message->getMailId());
                break;
            case self::OPTION_SINGLE_DEL:
                $code = $this->singleMailDel($this->message->getMailId());
                break;
            case self::OPTION_ALL_DELETE_ALREADY_READ:
                $code = $this->allMailDel($this->message->getMailType());
                break;
            case self::OPTION_ALL_GET_ENCLOSURE:
                $code = $this->allMailGetEnclosure($this->message->getMailType());
                break;
        }
        if (is_null($code)) {
            $code = ClientErrorCode::MAIL_OPTION_ERROR;
        }
        $this->sendMessage->setCode($code);
        $this->sendMessage->setOption($option);
        SendMessage::getInstance()->sendClient(PacketId::GC_MailOptionResult, $this->sendMessage);
        //发送邮件消息
        $this->sendMailMessage();
        return ErrorDefine::SUCCESS;
    }
}
