<?php

/**
 * 退出登录
 */

namespace Game\Controller\Login;

use Framework\Define\ErrorDefine;
use Framework\Logic\OnLineLogic;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\GameConstantDefine;
use Game\Logic\AccountLogic;
use Game\Protobuf\CGLogOut;
use Game\Protobuf\GCLogOut;
use Game\Protobuf\PacketId;
use Game\Logic\CommonConstLogic;

class Logout extends ControllerBase
{
    use AccountLogic;
    use OnLineLogic;
    use CommonConstLogic;

    private GCLogOut $sendMessage;

    public function __construct()
    {
        $this->message = new CGLogOut();
        $this->sendMessage = new GCLogOut();
    }

    public function run(): int
    {
        // TODO:: 退出游戏预留处理
        $this->upRoleStatus(GameConstantDefine::PLAYER_STATUS_OFFLINE, $this->playerId);
        $this->updateTimeById($this->playerId, 0);
        $this->sendLogoutMsg(ClientErrorCode::CLIENT_SUCCESS);
        return ErrorDefine::SUCCESS;
    }

    private function sendLogoutMsg(int $code) {
        $this->sendMessage->setCode($code);
        SendMessage::getInstance()->sendClient(PacketId::GC_LogOut, $this->sendMessage);
    }

}
