<?php

/**
 * Login.php
 * 文件描述
 * Created On 2021/12/29
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Game\Controller\Login;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Game\Logic\AccountLogic;
use Game\Protobuf\CGLoginCheckMsg;
use Game\Logic\CommonConstLogic;

class LoginCheck extends ControllerBase
{
    use AccountLogic;
    use CommonConstLogic;

    public function __construct()
    {
        $this->message = new CGLoginCheckMsg();
    }

    public function run(): int
    {
        $isRegister = $this->message->getIsRegister();
        $this->loginCheckMsg($this->playerId, $isRegister);
        return ErrorDefine::SUCCESS;
    }

}
