<?php
/**
 * 比赛后点赞
 * @date 2022/6/15/015
 * @author JZW
 **/
namespace Game\Controller\Likes;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\LikesLogic;
use Game\Protobuf\CGPaiWeiLikes;
use Game\Protobuf\GCPaiWeiLikes;
use Game\Protobuf\PacketId;

class RankLikes extends ControllerBase
{
    use LikesLogic;

    private GCPaiWeiLikes $sendMessage;

    public function __construct()
    {
        $this->message = new CGPaiWeiLikes();
        $this->sendMessage = new GCPaiWeiLikes();
    }

    public function run(): int
    {
        $otherId = $this->message->getPlayerId();
        $matchId = $this->message->getMatchId();

        $this->sendMessage->setCode($this->addLikes($otherId, $matchId));
        $this->sendMessage->setPlayerId($otherId);
        $this->sendMessage->setMatchId($matchId);
        $this->sendMessage->setLikesNum($this->getLikesNum($otherId, $matchId));

        SendMessage::getInstance()->sendClient(PacketId::GC_PaiWeiLikes, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}