<?php

/**
 * 新手引导 加入匹配
 */

namespace Game\Controller\Guide;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Pvp\GuideJoinMatchLogic;
use Game\Protobuf\CGGuideMatching;
use Game\Protobuf\GCGuideMatching;
use Game\Protobuf\PacketId;

class CG_GuideMatching extends ControllerBase
{
    use GuideJoinMatchLogic;

    private GCGuideMatching $sendMessage;

    public function __construct()
    {
        $this->message = new CGGuideMatching();
        $this->sendMessage = new GCGuideMatching();
    }

    public function run(): int
    {
        [$mapId, $matchType] = $this->getGuideMatchConfigByNum($this->message->getNum());
        $this->sendMessage->setJoinId(
            $this->getGuideJoinMatchingJoinId(
                $this->message->getNum()
            )
        );
        $this->sendMessage->setSceneId($mapId);
        $this->sendMessage->setMatchType($matchType);
        $this->sendMessage->setPInfo(
            $this->getGuideMatchPlayerInfo(
                $this->playerId,
                $this->message->getNum()
            )
        );
        $this->sendMessage->setAInfo(
            $this->getGuideMatchAIInfoByNum(
                $this->message->getNum()
            )
        );
        //更新记录和任务
        $this->updateRecordAndTask(
            $this->playerId,
            $this->sendMessage
        );
        SendMessage::getInstance()->sendClient(PacketId::GC_GuideMatching, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
