<?php

/**
 * 游客
 */

namespace Game\Controller\Guest;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\GameConstantDefine;
use Game\Constant\TemplateDefine;
use Game\Data\AccountData;
use Game\Protobuf\CGCheckGuestByDeviceID;
use Game\Protobuf\GCCheckGuestByDeviceID;
use Game\Protobuf\PacketId;
use Game\Logic\CommonConstLogic;
use Game\Logic\AccountLogic;

class Guest extends ControllerBase
{
    use CommonConstLogic;
    use AccountLogic;
    private GCCheckGuestByDeviceID $sendMessage;
    private const GUEST_ID = 'GuestID';
    private const GUEST_MIN = 10000000;

    public function __construct()
    {
        $this->message = new CGCheckGuestByDeviceID();
        $this->sendMessage = new GCCheckGuestByDeviceID();
    }

    public function run(): int
    {
        $deviceID = $this->message->getDeviceID();

        if(!empty($deviceID)) {
             $playerID = $this->searchPlayerIdByDevice($deviceID);
             if($playerID != 0) {
                 $playerInfo = $this->searchPlayerInfo($playerID);
                 if(isset($playerInfo[AccountData::DB_PASSWORD]) && isset($playerInfo[AccountData::DB_ACCOUNT])) {
                    $this->sendGuestMsg(ClientErrorCode::CLIENT_SUCCESS,
                        $playerInfo[AccountData::DB_ACCOUNT], $playerInfo[AccountData::DB_PASSWORD]);
                     return ErrorDefine::SUCCESS;
                 }
             }
        }
        // 创建游客账号密码
        $account = $this->makeAccountID();
        $password = $this->makeAccountPwd();

        $this->sendGuestMsg(ClientErrorCode::CLIENT_SUCCESS, $account, $password);
        return ErrorDefine::SUCCESS;
    }

    private function sendGuestMsg(int $code, string $account, string $password) {
        $this->sendMessage->setCode($code);
        $this->sendMessage->setAccount($account);
        $this->sendMessage->setPassword($password);
        SendMessage::getInstance()->sendClient(PacketId::GC_CheckGuestByDeviceID, $this->sendMessage);
    }

    private function makeAccountID(): int {
        $res = $this->getCommonConstData();
        $accountID = self::GUEST_MIN;
        if(isset($res[self::GUEST_ID])) {
            $accountID = (int)$res[self::GUEST_ID] + 1;
        }
        $data = [
            self::GUEST_ID => $accountID
        ];
        $this->saveCommonConstData($data);
        return $accountID;
    }

    private function makeAccountPwd(): string {
        // 1-9  {49~57}   A-Z {65~90} a-z {97~122}
        $pwd = "";
        $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWSYZ123456789";
        $len = 5;
        for($i = 0; $i < $len; $i++) {
            $pwd .= $chars[random_int(0, strlen($chars) - 1)];
        }
        // 数字
        $pwd .= chr(random_int(49, 57));
        // 大写
        $pwd .= chr(random_int(65, 90));
        // 小写
        $pwd .= chr(random_int(97, 122));
        return $pwd;
    }
}
