<?php

/**
 * 游客绑定
 */

namespace Game\Controller\Guest;

use Framework\Define\ErrorDefine;
use Framework\Log\LogMark;
use Framework\Model\CommonModel;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\DBTableDefine;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Data\AccountData;
use Game\Model\AccountModel;
use Game\Protobuf\CGGuestBindAccount;
use Game\Protobuf\GCGuestBindAccount;
use Game\Protobuf\GCItemShow;
use Game\Protobuf\PacketId;
use Game\Logic\CommonConstLogic;
use Game\Logic\AccountLogic;
use Framework\DB\Handler\CommonDBHandler;
use Game\Protobuf\UseItemSingle;

class Bind extends ControllerBase
{
    use CommonDBHandler;
    use CommonConstLogic;
    use AccountLogic;
    private GCGuestBindAccount $sendMessage;

    public function __construct()
    {
        $this->message = new CGGuestBindAccount();
        $this->sendMessage = new GCGuestBindAccount();
    }

    public function run(): int
    {
        $account = $this->message->getAccount();
        $bindAccount = $this->message->getBindAccount();
        $channelType = $this->message->getChannelType();
        $deviceID = $this->message->getDeviceID();

        if(empty($account) || empty($bindAccount)) {
            // 绑定参数非法
            $this->sendMsg(ClientErrorCode::GUEST_BIND_PARAMS_ERROR);
            return ErrorDefine::SUCCESS;
        }
        // 判断是否已经绑定帐号
        /**
         * @var CommonModel $common
         */
        $common = ModelManager::getInstance()->getModel(ModelTypeDefine::COMMON);
        $val = $common->search(CommonModel::TYPE_PLAY_ACCOUNT_PLAYER, $bindAccount);
        if(!empty($val)) {
            $this->sendMsg(ClientErrorCode::GUEST_BIND_ACCOUNT_IS_EXIST_ERROR);
            return ErrorDefine::SUCCESS;
        }

        // 查询uuid
        /**
         * @var AccountModel $accountModel
         */
        $accountModel = ModelManager::getInstance()->getModel(ModelTypeDefine::ACCOUNT);
        $data = [
            1 => $this->playerId, // 用来删除设备表
            2 => $account,        // 删除 2 添加 3
            3 => $bindAccount,
            4 => $deviceID
        ];
        // Lua 脚本保持一致性
        $this->guestBind(DBTableDefine::TABLE_COMMON, 1, $data);

        $data = [
            AccountData::DB_ACCOUNT_TYPE => AccountData::PLAYER_NORMAL,
        ];
        if (!$accountModel->saveAccount($data)){
            LogMark::getInstance()->markError(ErrorDefine::ERROR_INTERNAL,
                'guest bind change account to normal type error!');
            $this->sendMsg(ClientErrorCode::GUEST_BIND_CHANGE_ACCOUNT_TYPE_ERROR);
            return ErrorDefine::SUCCESS;
        }

        // 发放绑定奖励道具
        $bindItemID = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_Guest_Bind_Reward_ItemID, TemplateConst::ConstNum);
        $this->setLogAddItemSource(GameConstantDefine::ITEM_ADD_SOURCE_GUEST_BIND_REWARD);
        $this->gainItemArr([$bindItemID => 1]);
        $this->sendItemShowMsg($bindItemID);
        $this->sendMsg(ClientErrorCode::CLIENT_SUCCESS, $bindAccount, $channelType);
        return ErrorDefine::SUCCESS;
    }

    private function sendMsg(int $code, string $account = "", int $channelType = 0) {
        $this->sendMessage->setCode($code);
        $this->sendMessage->setAccount($account);
        $this->sendMessage->setType(AccountData::PLAYER_NORMAL);
        $this->sendMessage->setChannelType($channelType);
        SendMessage::getInstance()->sendClient(PacketId::GC_GuestBindAccount, $this->sendMessage);
    }

    private function sendItemShowMsg($itemID) {
        $msg = new GCItemShow();
        $itemMsg = new UseItemSingle();
        $itemMsg->setTplID($itemID);
        $itemMsg->setNum(1);
        $msg->setItems([$itemMsg]);
        SendMessage::getInstance()->sendClient(PacketId::GC_ItemShow, $msg);
    }
}
