<?php

/**
 * svn 更新
 */

namespace Game\Controller\Gm;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendServiceMsg;
use Game\Constant\ClientErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Data\AccountData;
use Game\Logic\AccountLogic;
use Game\Model\AccountModel;
use Game\Protobuf\GCSyncBanPlayer;
use Game\Protobuf\GMBanPlayer;
use Game\Protobuf\GMSvnUP;
use Game\Protobuf\MGBanPlayer;
use Game\Protobuf\MGSvnUP;
use Game\Protobuf\PacketId;
use Gm\Config\ErrorCode;

class SvnUP extends ControllerBase
{
    use AccountLogic;

    private GMSvnUP $sendMessage;

    public function __construct()
    {
        $this->message = new MGSvnUP();
        $this->sendMessage = new GMSvnUP();
    }

    public function run(): int
    {
        $dir = $this->message->getSvnDir();
        $shell = "bash ". $dir;
        exec($shell, $result, $status);
        if($status) {
            $this->SendMsg(ErrorCode::ERROR_SVN_UP_FAILED, json_encode($result));
        } else {
            $this->SendMsg(ErrorCode::SUCCESS, json_encode($result));
        }
        return ErrorDefine::SUCCESS;
    }

    private function SendMsg(int $code = ErrorCode::SUCCESS, string $msg = "") {
        $this->sendMessage->setCode(ErrorCode::SUCCESS);
        $this->sendMessage->setExecMsg($msg);
        SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_SvnUP, $this->sendServer,
            $this->sendMessage, 0, Utils::getServerTimestamp());
    }
}
