<?php

/**
 * 服务器状态
 */

namespace Game\Controller\Gm;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendServiceMsg;
use Game\Constant\ClientErrorCode;
use Game\Protobuf\GCGetServerState;
use Game\Protobuf\GMServerState;
use Game\Protobuf\MGServerState;
use Game\Protobuf\PacketId;
use Gm\Config\ErrorCode;
use Game\Logic\CommonConstLogic;
use Tool\InitServer\Config;
use Framework\Logic\OnLineLogic;
use Framework\Logic\PacketCacheLogic;

class ServerState extends ControllerBase
{
    use CommonConstLogic;
    use OnLineLogic;
    use PacketCacheLogic;

    private GMServerState $sendMessage;
    private GCGetServerState $sendMsg;

    private const TYPE_OPTION_SEARCH = 1;   //查询
    private const TYPE_OPTION_UPDATE = 2;   //修改

    public function __construct()
    {
        $this->message = new MGServerState();
        $this->sendMessage = new GMServerState();
        $this->sendMsg = new GCGetServerState();
    }

    public function run(): int
    {
        $option = $this->message->getOption();
        $state = $this->message->getState();

        if ($option === self::TYPE_OPTION_SEARCH) {
            // 查询服务器状态
            return $this->sendSuccessMessage(ErrorCode::SUCCESS);
        }

        // 修改服务器状态
        $this->gmChangeServerState($state);

        return $this->sendSuccessMessage(ErrorCode::SUCCESS);
    }

    private function sendSuccessMessage(int $code): int
    {
        $result = $this->getCommonConstData();
        if(!isset($result[Config::SERVER_STATE_KEY])) {
            // 如果没有查到 则初始化开服至服务器
            $data = array(
                Config::SERVER_STATE_KEY => Config::SERVER_TYPE_OPENING,
            );
            $this->saveCommonConstData($data);
            $result = $this->getCommonConstData();
        }
        $state = $result[Config::SERVER_STATE_KEY];
        $this->sendMessage->setCode($code);
        $this->sendMessage->setState($state);

        SendServiceMsg::getInstance()->sendServiceMsg(
            PacketId::GM_ServerState,
            $this->sendServer,
            $this->sendMessage,
            0,
            Utils::getServerTimestamp()
        );
        return ErrorDefine::SUCCESS;
    }

    private function gmChangeServerState(int $state) {
        $data = array(
            Config::SERVER_STATE_KEY => $state,
        );
        $this->saveCommonConstData($data);
        // 修改为关服则 通知在线玩家关服
        if(!$this->getOnLinePlayerId($onlinePlayerIDS)) {
            $onlinePlayerIDS = [];
        }
        $this->sendMsg->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMsg->setState($state);
        $this->sendMsg->setStartTime(time());
        foreach($onlinePlayerIDS as $playerID=>$time) {
            ModelManager::getInstance()->setPlayerId($playerID);
            $this->playerId = $playerID;
            $this->addPacket(PacketId::GC_GetServerState, $this->sendMsg, $playerID);
        }
    }
}
