<?php

/**
 * 服务器模块
 */

namespace Game\Controller\Gm;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendServiceMsg;
use Game\Constant\ClientErrorCode;
use Game\Protobuf\GCSyncCloseModule;
use Game\Protobuf\GMServerModule;
use Game\Protobuf\MGServerModule;
use Game\Protobuf\PacketId;
use Gm\Config\ErrorCode;
use Game\Logic\CommonConstLogic;
use Tool\InitServer\Config;
use Framework\Logic\OnLineLogic;
use Framework\Logic\PacketCacheLogic;

class ServerModule extends ControllerBase
{
    use CommonConstLogic;
    use OnLineLogic;
    use PacketCacheLogic;

    private GMServerModule $sendMessage;
    private GCSyncCloseModule $sendMsg;

    private const TYPE_OPTION_SEARCH = 1;   //查询
    private const TYPE_OPTION_UPDATE = 2;   //修改

    public function __construct()
    {
        $this->message = new MGServerModule();
        $this->sendMessage = new GMServerModule();
        $this->sendMsg = new GCSyncCloseModule();
    }

    public function run(): int
    {
        $option = $this->message->getOption();
        $module = $this->message->getCloseModule();
        $cModule = [];
        foreach ($module as $id) {
            $cModule[] = $id;
        }

        if ($option === self::TYPE_OPTION_SEARCH) {
            // 查询模块状态
            return $this->sendSuccessMessage(ErrorCode::SUCCESS);
        }

        // 修改模块状态
        $this->gmChangeModuleState($cModule);

        return $this->sendSuccessMessage(ErrorCode::SUCCESS);
    }

    private function sendSuccessMessage(int $code): int
    {
        $result = $this->getCommonConstData();
        if(!isset($result[Config::SERVER_MODULE_KEY])) {
            // 如果没有查到 则初始化开服至服务器
            $data = array(
                Config::SERVER_MODULE_KEY => json_encode([]),
            );
            $this->saveCommonConstData($data);
            $result = $this->getCommonConstData();
        }
        $module = json_decode($result[Config::SERVER_MODULE_KEY], true);
        $this->sendMessage->setCode($code);
        $this->sendMessage->setCloseModule($module);

        SendServiceMsg::getInstance()->sendServiceMsg(
            PacketId::GM_ServerModule,
            $this->sendServer,
            $this->sendMessage,
            0,
            Utils::getServerTimestamp()
        );
        return ErrorDefine::SUCCESS;
    }

    private function gmChangeModuleState($module) {
        $data = array(
            Config::SERVER_MODULE_KEY => json_encode($module),
        );
        $this->saveCommonConstData($data);
        // 给所有在线玩家发送更新消息
        if(!$this->getOnLinePlayerId($onlinePlayerIDS)) {
            $onlinePlayerIDS = [];
        }
        $this->sendMsg->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMsg->setCloseModuleID($module);
        foreach($onlinePlayerIDS as $playerID=>$time) {
            ModelManager::getInstance()->setPlayerId($playerID);
            $this->playerId = $playerID;
            $this->addPacket(PacketId::GC_SyncCloseModule, $this->sendMsg, $playerID);
        }
    }
}
