<?php
/**
 * GM 排位信息
 **/
namespace Game\Controller\Gm;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendServiceMsg;
use Game\Logic\PaiweiLevelLogic;
use Gm\Config\ErrorCode;
use Game\Protobuf\PacketId;
use Game\Protobuf\GMRankScore;
use Game\Protobuf\MGRankScore;
use Game\Logic\AccountLogic;

class Rank extends ControllerBase
{
    use AccountLogic;
    use PaiweiLevelLogic;

    public const RANK_SEARCH = 1;
    public const RANK_CHANGE = 2;

    public GMRankScore $rankScore;

    public function __construct() {
        $this->message = new MGRankScore();
        $this->rankScore = new GMRankScore();
    }

    public function run(): int
    {
        $account = $this->message->getAccount();
        $option = $this->message->getOption();
        $score = $this->message->getScore();
        $guardScore = $this->message->getGuardScore();
        
        if(empty($account)) {
            $this->rankScore->setCode(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
            SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_RankScore, $this->sendServer,
                $this->rankScore, 0, Utils::getServerTimestamp());
            return ErrorDefine::SUCCESS;
        }

        // 查询id
        $playerID = $this->searchPlayerIdByNickName($account);

        if(empty($playerID)) {
            $this->rankScore->setCode(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
            SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_RankScore, $this->sendServer,
                $this->rankScore, 0, Utils::getServerTimestamp());
            return ErrorDefine::SUCCESS;
        }
        ModelManager::getInstance()->clearModelList();
        ModelManager::getInstance()->setPlayerId($playerID);
        switch($option)
        {
            case self::RANK_SEARCH:
                $info = $this->getPaiweiLevel();
                $this->rankScore->setCode(ErrorCode::SUCCESS);
                $this->rankScore->setInfo(json_encode($info));
                SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_RankScore, $this->sendServer,
                    $this->rankScore, 0, Utils::getServerTimestamp());
                return ErrorDefine::SUCCESS;
            case self::RANK_CHANGE:
                $this->gmChangeScore($score, $guardScore);
                $info = $this->getPaiweiLevel();
                $this->rankScore->setCode(ErrorCode::SUCCESS);
                $this->rankScore->setInfo(json_encode($info));
                SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_RankScore, $this->sendServer,
                    $this->rankScore, 0, Utils::getServerTimestamp());
                return ErrorDefine::SUCCESS;
        }
        return true;
    }

}