<?php

/**
 * 禁言玩家
 */

namespace Game\Controller\Gm;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendServiceMsg;
use Game\Constant\ClientErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Data\AccountData;
use Game\Logic\AccountLogic;
use Game\Model\AccountModel;
use Game\Protobuf\GCSyncProhibitionPlayer;
use Game\Protobuf\GMProhibitionPlayer;
use Game\Protobuf\MGProhibitionPlayer;
use Game\Protobuf\PacketId;
use Gm\Config\ErrorCode;

class ProhibitionPlayer extends ControllerBase
{
    use AccountLogic;

    private GMProhibitionPlayer $sendMessage;
    private GCSyncProhibitionPlayer $sendMsg;

    private const TYPE_OPTION_SEARCH = 1;   //查询
    private const TYPE_OPTION_UPDATE = 2;   //修改

    public function __construct()
    {
        $this->message = new MGProhibitionPlayer();
        $this->sendMessage = new GMProhibitionPlayer();
        $this->sendMsg = new GCSyncProhibitionPlayer();
    }

    public function run(): int
    {
        $role_id = $this->message->getRoleID();
        $nick_name = $this->message->getNickName();
        $option = $this->message->getOption();
        $ctime = $this->message->getCTime();      // 自定义时间 (time)
        $prohibition_time = $this->message->getProhibitionTime(); // 快捷时间（s）

        if(!empty($role_id)) {
            $playerID = $this->searchPlayerIdByRoleID($role_id);
        } else {
            $playerID = $this->searchPlayerIdByNickName($nick_name);
        }

        if(empty($playerID)) {
            $this->sendMessage->setCode(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
            SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_ProhibitionPlayer, $this->sendServer,
                $this->sendMessage, 0, Utils::getServerTimestamp());
            return ErrorDefine::SUCCESS;
        }

        if($option == self::TYPE_OPTION_SEARCH) {
            $this->sendMsg($playerID);
            return ErrorDefine::SUCCESS;
        }
        if(empty($ctime)) {
            $time = Utils::getServerTimestamp() + $prohibition_time;
        } else {
            $time = $ctime;
        }
        $data = [
            AccountData::DB_PROHIBITION_TIME => $time
        ];
        /**
         * @var AccountModel $accountModel
         */
        $accountModel = ModelManager::getInstance()->getModel(ModelTypeDefine::ACCOUNT);
        $accountModel->setPlayerId($playerID);
        $accountModel->saveAccount($data);
        $this->sendMsg($playerID);
        $this->SendClientData($playerID, $time);
        return ErrorDefine::SUCCESS;
    }

    private function SendMsg($playerID) {
        ModelManager::getInstance()->setPlayerId($playerID);
        $banTime = $this->getAccountProperty($playerID, AccountData::DB_PROHIBITION_TIME);
        if(is_null($banTime)) {
            $banTime = 0;
        }
        $this->sendMessage->setCode(ErrorCode::SUCCESS);
        $this->sendMessage->setTime($banTime);
        SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_ProhibitionPlayer, $this->sendServer,
            $this->sendMessage, 0, Utils::getServerTimestamp());
    }

    private function SendClientData($playerID, int $time) {
        ModelManager::getInstance()->setPlayerId($playerID);
        $this->sendMsg->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMsg->setTime($time);
        $this->addPacket(PacketId::GC_SyncProhibitionPlayer, $this->sendMsg, $playerID);
    }
}
