<?php

/**
 * 一键开启全部生涯关卡
 */

namespace Game\Controller\Gm;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\Logic\TemplateHelp;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendServiceMsg;
use Game\Constant\ConstTemplate\TemplateInitPlayer;
use Game\Constant\ConstTemplate\TemplateTale;
use Game\Constant\EventTypeDefine;
use Game\Constant\GameConstantDefine;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\GameLive;
use Game\Logic\AccountLogic;
use Game\Model\PVE\PveModel;
use Game\Protobuf\GMOpenGameLevel;
use Game\Protobuf\MGOpenGameLevel;
use Game\Protobuf\PacketId;
use Gm\Config\ErrorCode;

class OpenGameLevel extends ControllerBase
{
    use AccountLogic;
    use TemplateHelp;

    private GMOpenGameLevel $sendMessage;

    public function __construct()
    {
        $this->message = new MGOpenGameLevel();
        $this->sendMessage = new GMOpenGameLevel();
    }

    public function run(): int
    {
        $account = $this->message->getAccount();
        //检查校验
        if(empty($account)) {
            return $this->sendMessage(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
        }
        $playerId = $this->searchPlayerIdByNickName($account);
        if ($playerId == 0) {
            return $this->sendMessage(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
        }
        ModelManager::getInstance()->clearModelList();
        ModelManager::getInstance()->setPlayerId($playerId);
        GameLive::getInstance()->InitProtagonistPlayerId($playerId);
        /**
         * @var PveModel $pveModel
         */
        $pveModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PVE);
        //开启全部生涯关卡
        $config = $this->getTitle(TemplateDefine::TYPE_INIT_PLAYER, TemplateInitPlayer::DEFAULT_ID);
        $gameLevelConfig = $config[TemplateInitPlayer::CareerLevel];
        foreach ($gameLevelConfig as $chapterId => $levelArray) {
            $pveModel->createCareerChapter($chapterId);
            $levelIds = array();
            foreach ($levelArray as $levelIdArr) {
                foreach ($levelIdArr as $levelId) {
                    $levelIds[$levelId] = 0;
                    $pveModel->createCareerLevel($levelId);
                }
            }
            $pveModel->updateCareerChapterData($chapterId, $levelIds);
        }
        //开启全部驾照关卡
        for ($chapterId = TemplateTale::DRIVING_LICENSE_LEVEL_C; $chapterId <= TemplateTale::DRIVING_LICENSE_LEVEL_MAX; $chapterId++) {
            //解锁全部关卡
            if (isset($config[TemplateInitPlayer::DrivingLicenseLevel][$chapterId])) {
                $pveModel->createChapter($chapterId);
                $chapterData = $pveModel->getChapterData($chapterId);
                $chapterData->drivingLicenseDate = Utils::getServerTimestamp();
                $chapterData->updateDB();
                $pveModel->makeDrivingLicense($chapterId);
                foreach ($config[TemplateInitPlayer::DrivingLicenseLevel][$chapterId] as $levelId) {
                    $pveModel->createLevel($levelId);
                    $param = array(
                        GameConstantDefine::EVENT_KEY_PVE_LEVEL_ID => $levelId,
                    );
                    $this->triggerEvent(EventTypeDefine::EVENT_TYPE_TASK_COMPLETE_PVE_LEVEL, $param);
                }
            }
        }
        //开启全部技巧教学关卡
        foreach ($config[TemplateInitPlayer::TeachingSkillLevel] as $chapterId => $configData) {
            $pveModel->updateTeachingSkillLv($chapterId);
            $pveModel->createTeachingSkillChapter($chapterId);
            foreach ($config[TemplateInitPlayer::TeachingSkillLevel][$chapterId] as $levelId) {
                $pveModel->createLevel($levelId);
                $param = array(
                    GameConstantDefine::EVENT_KEY_PVE_LEVEL_ID => $levelId,
                );
                $this->triggerEvent(EventTypeDefine::EVENT_TYPE_TASK_COMPLETE_PVE_LEVEL, $param);
            }
        }
        return $this->sendMessage(ErrorCode::SUCCESS);
    }

    private function sendMessage(int $code): int
    {
        $this->sendMessage->setCode($code);
        SendServiceMsg::getInstance()->sendServiceMsg(
            PacketId::GM_OpenGameLevel,
            $this->sendServer,
            $this->sendMessage,
            0,
            Utils::getServerTimestamp()
        );
        return ErrorDefine::SUCCESS;
    }
}
