<?php
/**
 * GM 发送货币
 **/
namespace Game\Controller\Gm;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendServiceMsg;
use Game\Constant\GameConstantDefine;
use Game\GameLive;
use Game\Logic\ItemLogic;
use Gm\Config\ErrorCode;
use Game\Protobuf\GMGainMoney;
use Game\Protobuf\PacketId;
use Game\Logic\AccountLogic;
use Game\Protobuf\MGGainMoney;
use Game\Logic\MoneyLogic;

class Money extends ControllerBase
{
    use AccountLogic;
    use MoneyLogic;
    use ItemLogic;

    public GMGainMoney $gmMoney;

    public function __construct() {
        $this->message = new MGGainMoney();
        $this->gmMoney = new GMGainMoney();
    }

    public function run(): int
    {
        $account = $this->message->getAccount();
        $type = $this->message->getType();
        $num = $this->message->getNum();

        if(empty($account)) {
            $this->gmMoney->setCode(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
            SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_GainMoney, $this->sendServer,
                $this->gmMoney, 0, Utils::getServerTimestamp());
            return ErrorDefine::SUCCESS;
        }

        // 查询id
        $playerID = $this->searchPlayerIdByNickName($account);

        if(empty($playerID)) {
            $this->gmMoney->setCode(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
            SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_GainMoney, $this->sendServer,
                $this->gmMoney, 0, Utils::getServerTimestamp());
            return ErrorDefine::SUCCESS;
        }
        ModelManager::getInstance()->clearModelList();
        ModelManager::getInstance()->setPlayerId($playerID);
        GameLive::getInstance()->InitProtagonistPlayerId($playerID);
        // 发送货币
        if($num > 0) {
            $this->setLogAddItemSource(GameConstantDefine::ITEM_ADD_SOURCE_GM);
            if(!$this->gmAddMoney($type, $num)) {
                $this->gmMoney->setCode(ErrorCode::ERROR_RUN_FAILED);
                SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_GainMoney, $this->sendServer,
                    $this->gmMoney, 0, Utils::getServerTimestamp());
                return ErrorDefine::SUCCESS;
            }
        } else {
            $this->setLogConsumeItemSource(GameConstantDefine::ITEM_ADD_SOURCE_GM);
            if(!$this->gmSubMoney($type, abs($num))) {
                $this->gmMoney->setCode(ErrorCode::ERROR_RUN_FAILED);
                SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_GainMoney, $this->sendServer,
                    $this->gmMoney, 0, Utils::getServerTimestamp());
                return ErrorDefine::SUCCESS;
            }
        }

        $this->gmMoney->setCode(ErrorCode::SUCCESS);
        SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_GainMoney, $this->sendServer,
            $this->gmMoney, 0, Utils::getServerTimestamp());
        return ErrorDefine::SUCCESS;
    }

}