<?php
/**
 * GM 发送邮件
 **/
namespace Game\Controller\Gm;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendServiceMsg;
use Game\Constant\ConstTemplate\TemplateItem;
use Game\Constant\TemplateDefine;
use Gm\Config\ErrorCode;
use Game\Protobuf\PacketId;
use Game\Protobuf\GMSendMail;
use Game\Logic\AccountLogic;
use Game\Protobuf\MGSendMail;
use Game\Logic\MailLogic;
use Framework\Logic\CommonMailLogic;

class Mail extends ControllerBase
{
    use AccountLogic;
    use MailLogic;
    use CommonMailLogic;

    public GMSendMail $sendMail;
    public const TYPE_ACCOUNT_MAIL = 1; // 用户邮件
    public const TYPE_COMMON_MAIL = 2;  // 系统邮件

    public function __construct() {
        $this->message = new MGSendMail();
        $this->sendMail = new GMSendMail();
    }

    public function run(): int
    {
        // 解析
        $account = $this->message->getAccount();
        $items = $this->message->getItemList();
        $type = $this->message->getType();
        $mailID = $this->message->getMailID();
        $createTime = $this->message->getCreateTime() ?? Utils::getServerTimestamp();

        $itemArr = [];
        foreach($items as $item) {
            isset($itemArr[$item->getItemID()]) ?
                $itemArr[$item->getItemID()] += $item->getItemNum() :
                $itemArr[$item->getItemID()] = $item->getItemNum();
        }

        $cfg = $this->getTitle(TemplateDefine::TYPE_MAIL, $mailID);
        if (is_null($cfg)) {
            $this->sendMail->setCode(ErrorCode::ERROR_MAIL_TPL_NOT_FOUND);
            SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_SendMail, $this->sendServer,
                $this->sendMail, 0, Utils::getServerTimestamp());
            return ErrorDefine::SUCCESS;
        }

        // 判断玩家和系统邮件
        switch($type) {
            case self::TYPE_ACCOUNT_MAIL:
                if(empty($account)) {
                    $this->sendMail->setCode(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
                    SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_SendMail, $this->sendServer,
                        $this->sendMail, 0, Utils::getServerTimestamp());
                    return ErrorDefine::SUCCESS;
                }
                // 查询id
                $playerID = $this->searchPlayerIdByNickName($account);

                if(empty($playerID)) {
                    $this->sendMail->setCode(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
                    SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_SendMail, $this->sendServer,
                        $this->sendMail, 0, Utils::getServerTimestamp());
                    return ErrorDefine::SUCCESS;
                }
                ModelManager::getInstance()->clearModelList();
                ModelManager::getInstance()->setPlayerId($playerID);
                if(!$this->createPlayerMail($mailID, $createTime, $itemArr)) {
                    $this->sendMail->setCode(ErrorCode::ERROR_RUN_FAILED);
                    SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_SendMail, $this->sendServer,
                        $this->sendMail, 0, Utils::getServerTimestamp());
                    return ErrorDefine::SUCCESS;
                }
                break;
            case self::TYPE_COMMON_MAIL:
                if (!$this->createCommonMail($mailID, $createTime)) {
                    $this->sendMail->setCode(ErrorCode::ERROR_RUN_FAILED);
                    SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_SendMail, $this->sendServer,
                        $this->sendMail, 0, Utils::getServerTimestamp());
                    return ErrorDefine::SUCCESS;
                }
                break;
        }

        $this->sendMail->setCode(ErrorCode::SUCCESS);
        SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_SendMail, $this->sendServer,
            $this->sendMail, 0, Utils::getServerTimestamp());
        return ErrorDefine::SUCCESS;
    }

}