<?php
/**
 * GM 发送道具
 **/
namespace Game\Controller\Gm;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendServiceMsg;
use Game\Constant\ConstTemplate\TemplateItem;
use Game\Constant\TemplateDefine;
use Game\GameLive;
use Game\Operation\EventLog\EventLog_Manager;
use Game\Operation\PlatformManager;
use Gm\Config\ErrorCode;
use Game\Protobuf\GMGainItem;
use Game\Protobuf\PacketId;
use Game\Protobuf\MGGainItem;
use Game\Logic\AccountLogic;
use Game\Logic\CarLogic;
use Game\Logic\ItemLogic;

class Item extends ControllerBase
{
    use AccountLogic;
    use CarLogic;
    use ItemLogic;

    public GMGainItem $gmItem;

    public function __construct() {
        $this->message = new MGGainItem();
        $this->gmItem = new GMGainItem();
    }

    public function run(): int
    {
        $account = $this->message->getAccount();
        $items = $this->message->getItemList();

        if(empty($account)) {
            $this->gmItem->setCode(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
            SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_GainItem, $this->sendServer,
                $this->gmItem, 0, Utils::getServerTimestamp());
            return ErrorDefine::SUCCESS;
        }
        // 查询id
        $playerID = $this->searchPlayerIdByNickName($account);

        if(empty($playerID)) {
            $this->gmItem->setCode(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
            SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_GainItem, $this->sendServer,
                $this->gmItem, 0, Utils::getServerTimestamp());
            return ErrorDefine::SUCCESS;
        }
        ModelManager::getInstance()->clearModelList();
        ModelManager::getInstance()->setPlayerId($playerID);
        GameLive::getInstance()->InitProtagonistPlayerId($playerID);

        // 发送道具
        foreach($items as $val) {
            $itemID = $val->getItemID();
            $itemNum = $val->getItemNum();
            $timeOut = $val->getTimeOut();
            if(is_null($this->getTitle(TemplateDefine::TYPE_ITEM, $itemID))) {
                $this->gmItem->setCode(ErrorCode::ERROR_TPL_ID_CAN_NOT);
                SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_GainItem, $this->sendServer,
                    $this->gmItem, 0, Utils::getServerTimestamp());
                return ErrorDefine::SUCCESS;
            }
            // gm 发车
            $cfg = $this->getTitle(TemplateDefine::TYPE_ITEM, $itemID);

            // gm 不能发放改装件
            if($cfg[TemplateItem::ItemType] === TemplateItem::ITEM_TYPE_CAR_REFIT) {
                $this->gmItem->setCode(ErrorCode::ERROR_ITEM_NOT_SEND);
                SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_GainItem, $this->sendServer,
                    $this->gmItem, 0, Utils::getServerTimestamp());
                return ErrorDefine::SUCCESS;
            }

            if($cfg[TemplateItem::ItemType] === TemplateItem::ITEM_TYPE_CAR) {
                if(empty($timeOut)) {
                    $time = $cfg[TemplateItem::UseId][1];
                } else {
                    $time = $timeOut * 60;
                }
                $num = (int)$itemNum;
                if(!$this->gmItemGainCar($cfg[TemplateItem::UseId][0], 1, $time, $itemID, $num)) {
                    $errorID = LogMark::getInstance()->getLastErrorID();
                    if ($errorID != 0) {
                        $this->gmItem->setCode($errorID);
                        SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_GainItem, $this->sendServer,
                            $this->gmItem, 0, Utils::getServerTimestamp());
                        return ErrorDefine::SUCCESS;
                    }
                    $this->gmItem->setCode(ErrorCode::ERROR_RUN_FAILED);
                    SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_GainItem, $this->sendServer,
                        $this->gmItem, 0, Utils::getServerTimestamp());
                    return ErrorDefine::SUCCESS;
                }
                continue;
            }

            if(empty($timeOut)) {
                if(!$this->gmGainItem($itemID, $itemNum)) {
                    $this->gmItem->setCode(ErrorCode::ERROR_RUN_FAILED);
                    SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_GainItem, $this->sendServer,
                        $this->gmItem, 0, Utils::getServerTimestamp());
                    return ErrorDefine::SUCCESS;
                }
            } else {
                $time = $timeOut * 60 + Utils::getServerTimestamp();
                if(!$this->gmGainExpireItem($itemID, $itemNum, $time)) {
                    $this->gmItem->setCode(ErrorCode::ERROR_RUN_FAILED);
                    SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_GainItem, $this->sendServer,
                        $this->gmItem, 0, Utils::getServerTimestamp());
                    return ErrorDefine::SUCCESS;
                }
            }
        }
        $this->gmItem->setCode(ErrorCode::SUCCESS);
        SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_GainItem, $this->sendServer,
            $this->gmItem, 0, Utils::getServerTimestamp());
        PlatformManager::getInstance()->close();
        return ErrorDefine::SUCCESS;
    }

}