<?php
/**
 * GM 排行榜清除
 **/
namespace Game\Controller\Gm;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendServiceMsg;
use Game\Logic\RankLogic;
use Game\Protobuf\GMClearRank;
use Game\Protobuf\MGClearRank;
use Gm\Config\ErrorCode;
use Game\Protobuf\PacketId;
use Game\Logic\AccountLogic;

class ClearRank extends ControllerBase
{
    use AccountLogic;
    use RankLogic;

    public const RANK_SINGLE = 1;  // 单个玩家
    public const RANK_ALL    = 2;  // 榜单
    public GMClearRank $gmMsg;

    public function __construct() {
        $this->message = new MGClearRank();
        $this->gmMsg = new GMClearRank();
    }

    public function run(): int
    {
        $account = $this->message->getAccount();
        $option = $this->message->getOption();
        $rankType = $this->message->getRankType();
        $mapID = $this->message->getMapID();

        if($option === self::RANK_SINGLE && empty($account)) {
            $this->gmMsg->setCode(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
            SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_ClearRank, $this->sendServer,
                $this->gmMsg, 0, Utils::getServerTimestamp());
            return ErrorDefine::SUCCESS;
        }

        switch($option) {
            case self::RANK_SINGLE:
                // 查询id
                $playerID = $this->searchPlayerIdByNickName($account);
                if(empty($playerID)) {
                    $this->gmMsg->setCode(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
                    SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_ClearRank, $this->sendServer,
                        $this->gmMsg, 0, Utils::getServerTimestamp());
                    return ErrorDefine::SUCCESS;
                }
                $this->clearRankPlayerInfoByPID($playerID, $rankType, $mapID);
                $this->gmMsg->setCode(ErrorCode::SUCCESS);
                SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_ClearRank, $this->sendServer,
                    $this->gmMsg, 0, Utils::getServerTimestamp());
                return ErrorDefine::SUCCESS;
            case self::RANK_ALL:
                $this->clearRankInfo($rankType, $mapID);
                $this->gmMsg->setCode(ErrorCode::SUCCESS);
                SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_ClearRank, $this->sendServer,
                    $this->gmMsg, 0, Utils::getServerTimestamp());
                return ErrorDefine::SUCCESS;
        }
        return true;
    }

}