<?php
/**
 * GM 修改成长任务
 **/
namespace Game\Controller\Gm;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendServiceMsg;
use Game\GameLive;
use Game\Logic\Task\TaskLogic;
use Game\Protobuf\GMChangeDevelopmentalTask;
use Game\Protobuf\MGChangeDevelopmentalTask;
use Gm\Config\ErrorCode;
use Game\Protobuf\PacketId;
use Game\Logic\AccountLogic;

class ChangeDevelopmentalTask extends ControllerBase
{
    use AccountLogic;
    use TaskLogic;

    public GMChangeDevelopmentalTask $sendMsg;

    public function __construct() {
        $this->message = new MGChangeDevelopmentalTask();
        $this->sendMsg = new GMChangeDevelopmentalTask();
    }

    public function run(): int
    {
        $account = $this->message->getAccount();
        $level = $this->message->getLevel();

        if(empty($account)) {
            $this->sendMsg->setCode(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
            SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_ChangeDevelopmentalTask,
                $this->sendServer, $this->sendMsg, 0, Utils::getServerTimestamp());
            return ErrorDefine::SUCCESS;
        }

        // 查询id
        $playerID = $this->searchPlayerIdByNickName($account);

        if(empty($playerID)) {
            $this->sendMsg->setCode(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
            SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_ChangeDevelopmentalTask,
                $this->sendServer, $this->sendMsg, 0, Utils::getServerTimestamp());
            return ErrorDefine::SUCCESS;
        }
        ModelManager::getInstance()->clearModelList();
        ModelManager::getInstance()->setPlayerId($playerID);
        GameLive::getInstance()->InitProtagonistPlayerId($playerID);

        $this->gmCompleteMainTask($level);
        $this->sendMsg->setCode(ErrorCode::SUCCESS);
        SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_ChangeDevelopmentalTask, $this->sendServer,
            $this->sendMsg, 0, Utils::getServerTimestamp());
        return ErrorDefine::SUCCESS;
    }

}