<?php
/**
 * GM 账号相关
 **/
namespace Game\Controller\Gm;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendServiceMsg;
use Game\Protobuf\PacketId;
use Gm\Config\ErrorCode;
use Game\Protobuf\GMSearchPlayerInfo;
use Game\Protobuf\MGSearchPlayerInfo;
use Game\Logic\AccountLogic;

class Account extends ControllerBase
{
    public GMSearchPlayerInfo $gmSearchInfo;
    use AccountLogic;

    public function __construct()
    {
        $this->message = new MGSearchPlayerInfo();
        $this->gmSearchInfo = new GMSearchPlayerInfo();
    }

    public function run(): int
    {
        $account = $this->message->getAccount();
        if(empty($account)) {
            $this->gmSearchInfo->setCode(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
            SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_SearchPlayerInfo, $this->sendServer,
                $this->gmSearchInfo, 0, Utils::getServerTimestamp());
            return ErrorDefine::SUCCESS;
        }

        // 查询id
        $playerID = $this->searchPlayerIdByNickName($account);

        if(empty($playerID)) {
            $this->gmSearchInfo->setCode(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
            SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_SearchPlayerInfo, $this->sendServer,
                $this->gmSearchInfo, 0, Utils::getServerTimestamp());
            return ErrorDefine::SUCCESS;
        }
        ModelManager::getInstance()->clearModelList();
        ModelManager::getInstance()->setPlayerId($playerID);

        // 查询信息 并返回
        $info = $this->searchPlayerInfo($playerID);

        if ($info == null) {
            $this->gmSearchInfo->setCode(ErrorCode::ERROR_ACCOUNT_NOT_FOUND);
            SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_SearchPlayerInfo, $this->sendServer,
                $this->gmSearchInfo, 0, Utils::getServerTimestamp());
            return ErrorDefine::SUCCESS;
        }
        $info['playerID'] = $playerID;

        $this->gmSearchInfo->setCode(ErrorCode::SUCCESS);
        $this->gmSearchInfo->setAccount(json_encode($info));
        SendServiceMsg::getInstance()->sendServiceMsg(PacketId::GM_SearchPlayerInfo, $this->sendServer,
            $this->gmSearchInfo, 0, Utils::getServerTimestamp());
        return ErrorDefine::SUCCESS;
    }

}