<?php

/**
 * SaveDress.php
 * 保存着装
 * Created On 2021/01/20
 */

namespace Game\Controller\GameBag;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\GameConstantDefine;
use Game\Logic\ItemLogic;
use Game\Protobuf\ClothData;
use Game\Protobuf\ClothSaveRecv;
use Game\Protobuf\ClothSaveSend;
use Game\Logic\AccountLogic;
use Game\Protobuf\PacketId;

class SaveDress extends ControllerBase
{
    use AccountLogic;
    use ItemLogic;

    public ClothSaveRecv $sendMessage;

    public function __construct()
    {
        $this->message = new ClothSaveSend();
        $this->sendMessage = new ClothSaveRecv();
    }

    public function run(): int
    {

        $sex = $this->message->getSex();
        /**
         * @var ClothData $cloth
         */
        $cloth = $this->message->getCloth();
        if(!empty($cloth->getHairId())) $clothArr[] = $cloth->getHairId();
        if(!empty($cloth->getFaceId())) $clothArr[] = $cloth->getFaceId();
        if(!empty($cloth->getUpClothId())) $clothArr[] = $cloth->getUpClothId();
        if(!empty($cloth->getDownClothId())) $clothArr[] = $cloth->getDownClothId();
        if(!empty($cloth->getShoesId())) $clothArr[] = $cloth->getShoesId();

        $code = $this->checkClothIsInvalid($clothArr);
        if ($code == ClientErrorCode::CLIENT_SUCCESS) {
            $this->saveDress($sex, json_encode($clothArr));
            $this->sendMessage->setSucc(true);
            $this->sendMessage->setSex($sex);
            $this->sendMessage->setCloth($cloth);
            //通知好友更新
            $this->upRoleStatus(GameConstantDefine::PLAYER_STATUS_ONLINE, $this->playerId);
        }
        $this->sendMessage->setCode($code);
        SendMessage::getInstance()->sendClient(PacketId::Cloth_Save_Recv, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}