<?php

/**
 * 获取当前服装
 */

namespace Game\Controller\GameBag;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\ClothLogic;
use Game\Protobuf\CGGetCloth;
use Game\Protobuf\GCGetCloth;
use Game\Protobuf\PacketId;

class CG_GetCloth extends ControllerBase
{
    use ClothLogic;

    private GCGetCloth $sendMessage;

    public function __construct()
    {
        $this->message = new CGGetCloth();
        $this->sendMessage = new GCGetCloth();
    }

    public function run(): int
    {
        [$clothFemale, $clothMale] = $this->getPlayerClothProtobuf($this->playerId);
        $this->sendMessage->setFemaleCloth($clothFemale);
        $this->sendMessage->setMaleCloth($clothMale);
        SendMessage::getInstance()->sendClient(PacketId::GC_GetCloth, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
