<?php
/**
 * 好友申请验证
 * @date 2022-4-7
 * @author JZW
 **/
namespace Game\Controller\Friend;

use Framework\Define\ErrorDefine;
use Framework\Lib\Utils;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Data\NoticeData;
use Game\Logic\Friend\FriendLogic;
use Game\Logic\NoticeLogic;
use Game\Protobuf\CGFriendVerify;
use Game\Protobuf\GCFriendVerify;
use Game\Protobuf\PacketId;
use Framework\Logic\PacketCacheLogic;


class verify extends ControllerBase
{
    use FriendLogic;
    use PacketCacheLogic;
    use NoticeLogic;

    public GCFriendVerify $sendMessage;

    public function __construct()
    {
        $this->message = new CGFriendVerify();
        $this->sendMessage = new GCFriendVerify();
    }

    public function run(): int
    {
        $status = $this->message->getVerify();
        $respondentPlayerId = $this->message->getPlayerId();
        $source = $this->message->getSource();
        $code = ClientErrorCode::CLIENT_SUCCESS;
        if ($status){
            $this->agree($this->playerId, $respondentPlayerId, $code);
        }else{
            $this->refuse($respondentPlayerId, $code);
        }

        $this->sendMessage->setCode($code);
        $this->sendMessage->setPlayerId($respondentPlayerId);
        SendMessage::getInstance()->sendClient(PacketId::GC_FriendVerify, $this->sendMessage);

        return ErrorDefine::SUCCESS;
    }
}