<?php
/**
 * 更新备注
 * @date 2022-4-8
 * @author JZW
 **/


namespace Game\Controller\Friend;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\Friend\FriendLogic;
use Game\Protobuf\CGFriendUpRemark;
use Game\Protobuf\GCFriendUpRemark;
use Game\Protobuf\PacketId;

class upRemark extends ControllerBase
{
    use FriendLogic;

    public GCFriendUpRemark $sendMessage;

    public function __construct()
    {
        $this->message = new CGFriendUpRemark();
        $this->sendMessage = new GCFriendUpRemark();
    }

    public function run(): int
    {
        $this->remark(
            $this->message->getPlayerId(),
            $this->message->getRemark(),
            $ret,
            $code
        );
        if ($code == ClientErrorCode::CLIENT_SUCCESS) {
            $this->sendMessage->setInfo($ret[0]);
            $this->sendMessage->setInfoExt($ret[1]);
        }
        $this->sendMessage->setCode($code);
        SendMessage::getInstance()->sendClient(PacketId::GC_FriendUpRemark, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}