<?php
/**
 * 好友拒绝比赛邀请
 * @date 2022-4-22
 * @author JZW
 **/


namespace Game\Controller\Friend;


use Framework\Lib\Utils;
use Framework\MVC\ControllerBase;
use Game\Data\NoticeData;
use Game\Logic\NoticeLogic;
use Game\Protobuf\CGFriendRejectGameInvitation;

class rejectInvitation extends ControllerBase
{
    use NoticeLogic;

    public function __construct()
    {
        $this->message = new CGFriendRejectGameInvitation();
    }

    public function run(): int
    {
        $otherId = $this->message->getPlayerId();
        $tipsId = $this->message->getTipsId();
        $data = [
            "Time" => Utils::getServerTimestamp(),
            "TipsId" => $tipsId,
        ];
        $this->tipsNotice($otherId, NoticeData::Notice_Index_Tips, $data);
        $this->delNotice($otherId, NoticeData::Notice_Index_Invited_Game);
        return true;
    }
}