<?php
/**
 * 精确查找
 * @date 2022-4-8
 * @author JZW
 **/
namespace Game\Controller\Friend;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Friend\FriendLogic;
use Game\Protobuf\CGFriendPreciseFilter;
use Game\Protobuf\GCFriendPreciseFilter;
use Game\Protobuf\PacketId;

class preciseFilter extends ControllerBase
{
    use FriendLogic;

    public GCFriendPreciseFilter $sendMessage;

    public function __construct()
    {
        $this->message = new CGFriendPreciseFilter();
        $this->sendMessage = new GCFriendPreciseFilter();
    }

    public function run(): int
    {
        $key = $this->message->getSearchKey();
        [$info, $infoExt] = $this->getPreciseSearchList($key);
        $this->sendMessage->setNum(count($info));
        $this->sendMessage->setInfo($info);
        $this->sendMessage->setInfoExt($infoExt);
        SendMessage::getInstance()->sendClient(PacketId::GC_FriendPreciseFilter, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}