<?php
/**
 * 一键点击拒绝好友申请
 * @date 2022-4-12
 * @author JZW
 **/


namespace Game\Controller\Friend;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ModelTypeDefine;
use Game\Data\RoleExtData;
use Game\Model\AccountModel;
use Game\Protobuf\CGFriendOneClickReject;
use Game\Protobuf\GCFriendOneClickReject;
use Game\Protobuf\PacketId;

class oneClick extends ControllerBase
{
    public GCFriendOneClickReject $sendMessage;

    public function __construct()
    {
        $this->message = new CGFriendOneClickReject();
        $this->sendMessage = new GCFriendOneClickReject();
    }

    public function run(): int
    {
        $switch = (int)$this->message->getSwitch();
        /**
         * @var AccountModel $account
         */
        $account = ModelManager::getInstance()->getModel(ModelTypeDefine::ACCOUNT);
        $account->updateRoleExt([RoleExtData::DB_FRIEND_REJECT => $switch]);
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        $this->sendMessage->setSwitch((bool)$switch);
        SendMessage::getInstance()->sendClient(PacketId::GC_FriendOneClickReject, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}