<?php
/**
 * 我的好友列表
 * @date 2022-4-7
 * @author JZW
 **/
namespace Game\Controller\Friend;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ModelTypeDefine;
use Game\Logic\Friend\FriendLogic;
use Game\Model\Friend\FriendModel;
use Game\Protobuf\CGFriendMineList;
use Game\Protobuf\GCFriendMineList;
use Game\Protobuf\PacketId;


class mineList extends ControllerBase
{
    use FriendLogic;

    public GCFriendMineList $sendMessage;

    public function __construct()
    {
        $this->message = new CGFriendMineList();
        $this->sendMessage = new GCFriendMineList();
    }

    public function run(): int
    {
        /**
         * @var FriendModel $friend
         */
        $friend = ModelManager::getInstance()->getModel(ModelTypeDefine::FRIEND);
        $page = $this->message->getPage();
        [$info, $infoExt] = $this->getMineList($page);
        $this->sendMessage->setPage($page);
        $this->sendMessage->setNum($friend->getMineNumber());
        $this->sendMessage->setInfo($info);
        $this->sendMessage->setInfoExt($infoExt);
        SendMessage::getInstance()->sendClient(PacketId::GC_FriendMineList, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}