<?php
/**
 *
 * @date 2022-4-21
 * @author JZW
 **/


namespace Game\Controller\Friend;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Friend\FriendLogic;
use Game\Protobuf\CGFriendLastGame;
use Game\Protobuf\GCFriendLastGame;
use Game\Protobuf\PacketId;

class lastGame extends ControllerBase
{
    use FriendLogic;

    public GCFriendLastGame $sendMessage;

    public function __construct()
    {
        $this->message = new CGFriendLastGame();
        $this->sendMessage = new GCFriendLastGame();
    }

    public function run(): int
    {
        if (!$this->getLastGamingList($ret)){
            $ret = [];
        }
        $this->sendMessage->setGame($ret);
        SendMessage::getInstance()->sendClient(PacketId::GC_FriendLastGame, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}