<?php
/**
 * 好友点赞
 * @date 2022-4-12
 * @author JZW
 **/
namespace Game\Controller\Friend;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\Friend\FriendLogic;
use Game\Protobuf\CGFriendGood;
use Game\Protobuf\GCFriendGood;
use Game\Protobuf\PacketId;


class good extends ControllerBase
{
    use FriendLogic;

    public GCFriendGood $sendMessage;

    public function __construct()
    {
        $this->message = new CGFriendGood();
        $this->sendMessage = new GCFriendGood();
    }

    public function run(): int
    {
        $respondentPlayerId = $this->message->getPlayerId();
        $this->sendMessage->setCode(
            $this->goodFriend($respondentPlayerId)
        );
        $this->sendMessage->setPlayerId($respondentPlayerId);
        SendMessage::getInstance()->sendClient(PacketId::GC_FriendGood, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}