<?php
/**
 * 删除好友
 * @date 2022-4-12
 * @author JZW
 **/


namespace Game\Controller\Friend;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Friend\FriendLogic;
use Game\Protobuf\CGFriendDelete;
use Game\Protobuf\GCFriendDelete;
use Game\Protobuf\PacketId;

class del extends ControllerBase
{
    use FriendLogic;
    public GCFriendDelete $sendMessage;

    public function __construct()
    {
        $this->message = new CGFriendDelete();
        $this->sendMessage = new GCFriendDelete();
    }

    public function run(): int
    {
        $respondentPlayerId = $this->message->getPlayerId();
        if (!$this->del($respondentPlayerId, $num,$ret)) {
            $code = $ret;
            $num = 0;
        }else{
            $code = ErrorDefine::SUCCESS;
        }
        $this->sendMessage->setCode($code);
        $this->sendMessage->setPlayerId($respondentPlayerId);
        $this->sendMessage->setNum($num);
        SendMessage::getInstance()->sendClient(PacketId::GC_FriendDelete, $this->sendMessage);
        return $code;
    }
}