<?php
/**
 * 条件搜索
 * @date 2022-4-8
 * @author JZW
 **/


namespace Game\Controller\Friend;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Friend\FriendLogic;
use Game\Protobuf\CGFriendConditionFilter;
use Game\Protobuf\GCFriendConditionFilter;
use Game\Protobuf\PacketId;

class conditionFilter extends ControllerBase
{
    use FriendLogic;

    public GCFriendConditionFilter $sendMessage;

    public function __construct()
    {
        $this->message = new CGFriendConditionFilter();
        $this->sendMessage = new GCFriendConditionFilter();
    }

    public function run(): int
    {
        [$info, $infoExt] = $this->getRandomSearchList(
            $this->message->getMale(),
            $this->message->getFemale(),
            $this->message->getLevel()
        );
        $this->sendMessage->setInfo($info);
        $this->sendMessage->setInfoExt($infoExt);
        SendMessage::getInstance()->sendClient(PacketId::GC_FriendConditionFilter, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}