<?php
/**
 * 黑名单列表
 * @date 2022-4-12
 * @author JZW
 **/


namespace Game\Controller\Friend;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Friend\FriendLogic;
use Game\Protobuf\CGFriendBlackList;
use Game\Protobuf\GCFriendBlackList;
use Game\Protobuf\PacketId;

class blackList extends ControllerBase
{
    use FriendLogic;
    public GCFriendBlackList $sendMessage;

    public function __construct()
    {
        $this->message = new CGFriendBlackList();
        $this->sendMessage = new GCFriendBlackList();
    }

    public function run(): int
    {
        $page = $this->message->getPage();
        [$info, $infoExt] = $this->getBlackList($page);
        $this->sendMessage->setPage($page);
        $this->sendMessage->setInfo($info);
        $this->sendMessage->setInfoExt($infoExt);
        SendMessage::getInstance()->sendClient(PacketId::GC_FriendBlackList, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}