<?php
/**
 * 黑名单添加移除
 * @date 2022-4-12
 * @author JZW
 **/


namespace Game\Controller\Friend;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Friend\FriendLogic;
use Game\Protobuf\CGFriendBlack;
use Game\Protobuf\GCFriendBlack;
use Game\Protobuf\PacketId;

class black extends ControllerBase
{
    use FriendLogic;
    public GCFriendBlack  $sendMessage;

    public function __construct()
    {
        $this->message = new CGFriendBlack();
        $this->sendMessage = new GCFriendBlack();
    }

    public function run(): int
    {
        $type = $this->message->getType();
        $respondentPlayerId = $this->message->getPlayerId();
        if ($type == 0){
            //添加黑名单
            $code = $this->addBlack($respondentPlayerId);
        }else{
            //移除黑名单
            $this->resetBlack($respondentPlayerId, $code);
        }
        $this->sendMessage->setCode($code);
        $this->sendMessage->setType($type);
        $this->sendMessage->setPlayerId($respondentPlayerId);
        SendMessage::getInstance()->sendClient(PacketId::GC_FriendBlack, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}