<?php
/**
 * 好友批量申请验证
 * @date 2022-4-7
 * @author JZW
 **/
namespace Game\Controller\Friend;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Friend\FriendLogic;
use Game\Protobuf\CGFriendBatchVerify;
use Game\Protobuf\GCFriendBatchVerify;
use Game\Protobuf\PacketId;


class batchVerify extends ControllerBase
{
    use FriendLogic;

    public GCFriendBatchVerify $sendMessage;

    public function __construct()
    {
        $this->message = new CGFriendBatchVerify();
        $this->sendMessage = new GCFriendBatchVerify();
    }

    public function run(): int
    {
        if ($this->refuseAll()){
            $code = ErrorDefine::SUCCESS;
        }
        $this->sendMessage->setCode($code);
        SendMessage::getInstance()->sendClient(PacketId::GC_FriendBatchVerify, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}