<?php
/**
 * 申请好友列表
 * @date 2022-4-8
 * @author JZW
 **/


namespace Game\Controller\Friend;


use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Data\RoleExtData;
use Game\Logic\AccountLogic;
use Game\Logic\Friend\FriendLogic;
use Game\Protobuf\CGFriendApplyList;
use Game\Protobuf\GCFriendApplyList;
use Game\Protobuf\PacketId;

class applyList extends ControllerBase
{
    use FriendLogic;
    use AccountLogic;

    public GCFriendApplyList $sendMessage;

    public function __construct()
    {
        $this->message = new CGFriendApplyList();
        $this->sendMessage = new GCFriendApplyList();
    }

    public function run(): int
    {
        $page = $this->message->getPage();
        [$info, $infoExt] = $this->getMineApplyList($page);
        $this->sendMessage->setPage($page);
        $this->sendMessage->setSwitch((bool)$this->getAccountProperty($this->playerId, RoleExtData::DB_FRIEND_REJECT));
        $this->sendMessage->setInfo($info);
        $this->sendMessage->setInfoExt($infoExt);
        SendMessage::getInstance()->sendClient(PacketId::GC_FriendApplyList, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}