<?php
/**
 * 邀请好友游戏
 * @date 2022-4-21
 * @author JZW
 **/


namespace Game\Controller\Friend;


use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Friend\FriendLogic;
use Game\Protobuf\CGFriendApplyGame;
use Game\Protobuf\GCFriendApplyGame;
use Game\Protobuf\PacketId;

class applyGame extends ControllerBase
{
    use FriendLogic;
    public GCFriendApplyGame $sendMessage;

    public function __construct()
    {
        $this->message = new CGFriendApplyGame();
        $this->sendMessage = new GCFriendApplyGame();
    }

    public function run(): int
    {
        $otherId = $this->message->getPlayerId();
        $romeId = $this->message->getRoomId();
        $gameType = $this->message->getGameType();
        $source = $this->message->getSource();
        $roomType = $this->message->getRoomType();
        $this->applyGame($this->playerId, $otherId, $romeId ,$gameType, $source, $code, $roomType);
        $this->sendMessage->setCode($code);
        $this->sendMessage->setPlayerId($otherId);
        SendMessage::getInstance()->sendClient(PacketId::GC_FriendApplyGame, $this->sendMessage);
        return true;
    }
}