<?php
/**
 *
 * @date 2022-4-1
 * @author JZW
 **/
namespace Game\Controller\Friend;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Friend\FriendLogic;
use Game\Protobuf\CGFriendApply;
use Game\Protobuf\GCFriendApply;
use Game\Protobuf\PacketId;


class apply extends ControllerBase
{
    use FriendLogic;

    public GCFriendApply $sendMessage;

    public function __construct()
    {
        $this->message = new CGFriendApply();
        $this->sendMessage = new GCFriendApply();
    }

    public function run(): int
    {
        $respondentPlayerId = $this->message->getPlayerId();
        $source = $this->message->getSource();
        $this->apply($this->playerId, $respondentPlayerId, $source,$code);
        $this->sendMessage->setCode($code);
        SendMessage::getInstance()->sendClient(PacketId::GC_FriendApply, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}