<?php

/**
 * 解除亲密关系
 */

namespace Game\Controller\Friend;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Friend\FriendLogic;
use Game\Protobuf\CGRemoveIntimacyTitle;
use Game\Protobuf\GCRemoveIntimacyTitle;
use Game\Protobuf\PacketId;

class CG_RemoveIntimacyTitle extends ControllerBase
{
    use FriendLogic;

    private GCRemoveIntimacyTitle $sendMessage;

    public function __construct()
    {
        $this->message = new CGRemoveIntimacyTitle();
        $this->sendMessage = new GCRemoveIntimacyTitle();
    }

    public function run(): int
    {
        $cdTime = 0;
        $this->sendMessage->setCode(
            $this->removeIntimacyTitle(
                $this->playerId,
                $this->message->getPlayerId(),
                $cdTime
            )
        );
        $this->sendMessage->setCDTime($cdTime);
        $this->sendMessage->setPlayerId($this->message->getPlayerId());
        SendMessage::getInstance()->sendClient(PacketId::GC_RemoveIntimacyTitle, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
