<?php

/**
 * 亲密关系申请信息操作
 */

namespace Game\Controller\Friend;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Friend\FriendLogic;
use Game\Protobuf\CGIntimacyApplyOption;
use Game\Protobuf\GCIntimacyApplyOption;
use Game\Protobuf\PacketId;

class CG_IntimacyApplyOption extends ControllerBase
{
    use FriendLogic;

    private GCIntimacyApplyOption $sendMessage;

    public function __construct()
    {
        $this->message = new CGIntimacyApplyOption();
        $this->sendMessage = new GCIntimacyApplyOption();
    }

    public function run(): int
    {
        $this->sendMessage->setCode(
            $this->intimacyApplyOption(
                $this->message->getApplyId(),
                $this->message->getOption()
            )
        );
        $this->sendMessage->setApplyId($this->message->getApplyId());
        SendMessage::getInstance()->sendClient(PacketId::GC_IntimacyApplyOption, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
